#-----------------------------------------------------------------------------
#
# OTBConfig.cmake - OTB CMake configuration file for external projects.
#
# This file is configured by OTB and used by the UseOTB.cmake module
# to load OTB's settings for an external project.

# Compute the installation prefix from this OTBConfig.cmake file location.
get_filename_component(OTB_INSTALL_PREFIX "${CMAKE_CURRENT_LIST_FILE}" PATH)
get_filename_component(OTB_INSTALL_PREFIX "${OTB_INSTALL_PREFIX}" PATH)
get_filename_component(OTB_INSTALL_PREFIX "${OTB_INSTALL_PREFIX}" PATH)
get_filename_component(OTB_INSTALL_PREFIX "${OTB_INSTALL_PREFIX}" PATH)
set(OTB_MODULES_DIR "${OTB_INSTALL_PREFIX}/lib/cmake/OTB-5.10/Modules")
set(OTB_PYTHONPATH "${OTB_INSTALL_PREFIX}/lib/otb/python")

# The C and C++ flags added by OTB to the cmake-configured flags.
set(OTB_REQUIRED_C_FLAGS "")
set(OTB_REQUIRED_CXX_FLAGS " /bigobj")
set(OTB_REQUIRED_LINK_FLAGS "")

# The OTB version number
set(OTB_VERSION_MAJOR "5")
set(OTB_VERSION_MINOR "10")
set(OTB_VERSION_PATCH "1")

# OTB's CMake directory with modules OTB uses.
set(OTB_CMAKE_DIR "${OTB_INSTALL_PREFIX}/lib/cmake/OTB-5.10")

# use Find*.cmake files included in OTB package for external dependencies. (OpenCV, GDAL etc..)
set(CMAKE_MODULE_PATH ${OTB_CMAKE_DIR} ${CMAKE_MODULE_PATH})

# The location of the UseOTB.cmake file.
set(OTB_USE_FILE "${OTB_INSTALL_PREFIX}/lib/cmake/OTB-5.10/UseOTB.cmake")

# Whether OTB was built with shared libraries.
set(OTB_BUILD_SHARED "ON")

# List of available OTB modules.
set(OTB_MODULES_ENABLED "OTB6S;OTBITK;OTBAnomalyDetection;OTBBoost;OTBGDAL;OTBCommon;OTBBoostAdapters;OTBOpenThreads;OTBOssim;OTBGeoTIFF;OTBOssimPlugins;OTBOSSIMAdapters;OTBObjectList;OTBMetadata;OTBImageBase;OTBGdalAdapters;OTBTinyXML;OTBVectorDataBase;OTBIOGDAL;OTBExtendedFilename;OTBIOBSQ;OTBIOLUM;OTBIOMSTAR;OTBIOMW;OTBIOONERA;OTBIORAD;OTBCurl;OTBCurlAdapters;OTBIOTileMap;OTBStreaming;OTBImageIO;OTBInterpolation;OTBTransform;OTBImageManipulation;OTBTestKernel;OTBPath;OTBVectorDataManipulation;OTBProjection;OTBVectorDataIO;OTBApplicationEngine;OTBStatistics;OTBChangeDetection;OTBAppChangeDetection;OTBCommandLine;OTBColorMap;OTBMoments;OTBLabelMap;OTBConversion;OTBFuzzy;OTBMuParser;OTBMathParser;OTBOpenCV;OTBLibSVM;OTBSVMLearning;OTBShark;OTBSupervised;OTBDempsterShafer;OTBIOXML;OTBIndices;OTBMajorityVoting;OTBSOM;OTBSampling;OTBAppClassification;OTBPointSet;OTBSiftFast;OTBDescriptors;OTBAppDescriptors;OTBDimensionalityReduction;OTBAppDimensionalityReduction;OTBWavelet;OTBAppDomainTransform;OTBSpatialObjects;OTBEdge;OTBAppEdge;OTBImageNoise;OTBAppFiltering;OTBConvolution;OTBPanSharpening;OTBAppFusion;OTBCarto;OTBAppProjection;OTBEndmembersExtraction;OTBUnmixing;OTBAppHyperspectral;OTBAppImageUtils;OTBAppIndices;OTBAppMathParser;OTBMuParserX;OTBMathParserX;OTBAppMathParserX;OTBAppMoments;OTBAppMorphology;OTBOpticalCalibration;OTBAppOpticalCalibration;OTBSARCalibration;OTBAppSARCalibration;OTBPolarimetry;OTBAppSARDecompositions;OTBAppSARPolarMatrixConvert;OTBAppSARPolarSynth;OTBCCOBIA;OTBSmoothing;OTBMeanShift;OTBMetrics;OTBMorphologicalProfiles;OTBLabelling;OTBOGRProcessing;OTBWatersheds;OTBAppSegmentation;OTBDEM;OTBStereo;OTBDisparityMap;OTBAppStereo;OTBAppTest;OTBTextures;OTBAppTextures;OTBAppVectorDataTranslation;OTBAppVectorUtils;OTBCommandLineParser;OTBOpenThreadsAdapters;OTBCloudDetection;OTBComplexImage;OTBCorner;OTBDensity;OTBDisplacementField;OTBOpenGL;OTBGLFW;OTBGlew;OTBGlut;OTBIce;OTBIceViewer;OTBLandSatClassifier;OTBLearningBase;OTBQt4;OTBMonteverdiCore;OTBQwt;OTBQtAdapters;OTBQtWidget;OTBMonteverdiGUI;OTBMapla;OTBMarkov;OTBMonteverdi;OTBMorphologicalPyramid;OTBObjectDetection;OTBRoadExtraction;OTBRCC8;OTBSWIGWrapper;OTBSeamCarving;OTBSimulation;OTBTimeSeries;OTBUrbanArea")

set(OTB_APPLICATION_PATH "${OTB_INSTALL_PREFIX}/lib/otb/applications")

# Import OTB targets.
set(OTB_CONFIG_TARGETS_FILE "${OTB_INSTALL_PREFIX}/lib/cmake/OTB-5.10/OTBTargets.cmake")
if(NOT OTB_TARGETS_IMPORTED)
  set(OTB_TARGETS_IMPORTED 1)
  include("${OTB_CONFIG_TARGETS_FILE}")
endif()

# Load module interface macros.
include("${OTB_INSTALL_PREFIX}/lib/cmake/OTB-5.10/OTBModuleAPI.cmake")

# Load application macros.
include(CMakeParseArguments)
include("${OTB_INSTALL_PREFIX}/lib/cmake/OTB-5.10/OTBApplicationMacros.cmake")

# Compute set of requested modules.
if(OTB_FIND_COMPONENTS)
  # Specific modules requested by find_package(OTB).
  set(OTB_MODULES_REQUESTED "${OTB_FIND_COMPONENTS}")
endif()
if(NOT OTB_MODULES_REQUESTED)
  # No specific modules requested.  Use all of them.
  set(OTB_MODULES_REQUESTED "${OTB_MODULES_ENABLED}")
endif()

# Load requested modules and their dependencies into variables:
#  OTB_LIBRARIES       = Libraries to link
#  OTB_INCLUDE_DIRS    = Header file search path
#  OTB_LIBRARY_DIRS    = Library search path (for outside dependencies)
otb_module_config(OTB ${OTB_MODULES_REQUESTED})
