# - Config file for the Shark package
# It defines the following variables
#  SHARK_INCLUDE_DIRS - include directories for SHARK
#  SHARK_LIBRARIES    - libraries to link against
#  SHARK_LIBRARY_DIRS - path to the libraries

	# Compute the installation prefix from this SharkConfig.cmake file location.
	get_filename_component(SHARK_INSTALL_PREFIX "${CMAKE_CURRENT_LIST_FILE}" PATH)
		get_filename_component(SHARK_INSTALL_PREFIX "${SHARK_INSTALL_PREFIX}" DIRECTORY)
		get_filename_component(SHARK_INSTALL_PREFIX "${SHARK_INSTALL_PREFIX}" DIRECTORY)
		get_filename_component(SHARK_INSTALL_PREFIX "${SHARK_INSTALL_PREFIX}" DIRECTORY)
 
set(SHARK_INCLUDE_DIRS "${SHARK_INSTALL_PREFIX}/include/shark/;C:/dashboard/otb/install_sb_x64/include/boost-1_60")
set(SHARK_LIBRARY_DIRS "${SHARK_INSTALL_PREFIX}/lib")
 
# Our library dependencies (contains definitions for IMPORTED targets)
include("${SHARK_INSTALL_PREFIX}/lib/cmake/Shark/SharkTargets.cmake")
 
# The Shark version number
set(SHARK_VERSION_MAJOR "3")
set(SHARK_VERSION_MINOR "0")
set(SHARK_VERSION_PATCH "0")

# The C and C++ flags added by Shark to the cmake-configured flags.
SET(SHARK_REQUIRED_C_FLAGS "/openmp")
SET(SHARK_REQUIRED_CXX_FLAGS "/openmp")
SET(SHARK_REQUIRED_EXE_LINKER_FLAGS "")
SET(SHARK_REQUIRED_SHARED_LINKER_FLAGS "")
SET(SHARK_REQUIRED_MODULE_LINKER_FLAGS "")

# The location of the UseShark.cmake file.
SET(SHARK_USE_FILE "${SHARK_INSTALL_PREFIX}/lib/cmake/Shark/UseShark.cmake")

set(SHARK_LIBRARIES "C:/dashboard/otb/install_sb_x64/lib/boost_system-vc140-mt-1_60.lib;C:/dashboard/otb/install_sb_x64/lib/boost_date_time-vc140-mt-1_60.lib;C:/dashboard/otb/install_sb_x64/lib/boost_filesystem-vc140-mt-1_60.lib;C:/dashboard/otb/install_sb_x64/lib/boost_program_options-vc140-mt-1_60.lib;C:/dashboard/otb/install_sb_x64/lib/boost_serialization-vc140-mt-1_60.lib;C:/dashboard/otb/install_sb_x64/lib/boost_thread-vc140-mt-1_60.lib;C:/dashboard/otb/install_sb_x64/lib/boost_unit_test_framework-vc140-mt-1_60.lib;C:/dashboard/otb/install_sb_x64/lib/boost_chrono-vc140-mt-1_60.lib;shark")
