
#include "otbGPUNDVIFilter.h"
#include "otbStandardFilterWatcher.h"
#include "otbMultiChannelExtractROI.h"
#include "otbImage.h"
#include "otbVectorImage.h"
#include "otbImageFileReader.h"
#include "otbImageFileWriter.h"
#include "itkRescaleIntensityImageFilter.h"

// NDVICPU inimage outimage sizex sizey nbthreads

int main(int argc, char *argv[])
{
  if (argc != 6)
    {
    std::cerr << "Wrong Parameters " << std::endl;
    std::cerr << "Usage: " << argv[0];
    std::cerr <<
    " inputImage outputImage sizex sizey nbthreads"
              << std::endl;
    return EXIT_FAILURE;
    }

  const unsigned int Dimension = 2;
  typedef float                                      PixelType;
  typedef otb::VectorImage<PixelType, Dimension> InputImageType;
  typedef otb::Image<PixelType, Dimension>      OutputImageType;

  typedef otb::ImageFileReader<InputImageType>  ReaderType;
  typedef otb::ImageFileWriter<OutputImageType> WriterType;
  

  typedef otb::GPUNDVIFilter<InputImageType, OutputImageType> FilterType;

  FilterType::Pointer filter = FilterType::New();

  unsigned int extractSizeX = atoi(argv[3]);
  unsigned int extractSizeY = atoi(argv[4]);
  unsigned int nbthreads = atoi(argv[5]);


  typedef otb::MultiChannelExtractROI<PixelType, PixelType> ExtractROIFilterType;


  ReaderType::Pointer reader = ReaderType::New();
  reader->SetFileName(argv[1]);

  ExtractROIFilterType::Pointer roiFilter = ExtractROIFilterType::New();

  roiFilter->SetStartX(0);
  roiFilter->SetStartY(0);
  roiFilter->SetSizeX(extractSizeX);
  roiFilter->SetSizeY(extractSizeY);

  roiFilter->SetInput( reader->GetOutput() );


  filter->SetRedIndex(2);
  filter->SetNIRIndex(3);

  filter->SetInput(roiFilter->GetOutput());


  filter->SetNumberOfThreads(1);

  WriterType::Pointer writer = WriterType::New();
  writer->SetFileName(argv[2]);
  writer->SetInput(filter->GetOutput());

  timespec startClock, endClock;
  time_t startTime = time(NULL);
  clock_t startNdvi = clock();
  clock_gettime(CLOCK_REALTIME, &startClock);

  writer->Update();
  
  clock_gettime(CLOCK_REALTIME, &endClock);
  clock_t endNdvi = clock();
  time_t endTime = time(NULL);
  

  std::cout << "Time1: " << std::setprecision(15)
            << (endNdvi-startNdvi)/((float) CLOCKS_PER_SEC) << std::endl;
  std::cout << "Time2: " << std::setprecision(15)
            << (endTime-startTime) << std::endl;
  std::cout << "Time3: " << std::setprecision(15)
            << (endClock.tv_sec-startClock.tv_sec) + (endClock.tv_nsec-startClock.tv_nsec)/1000000000. << std::endl;


  return EXIT_SUCCESS;
}
