

#include "otbSpectralAngleDistanceImageFilter.h"
#include "otbStandardFilterWatcher.h"
#include "otbMultiChannelExtractROI.h"
#include "otbImage.h"
#include "otbVectorImage.h"
#include "otbImageFileReader.h"
#include "otbImageFileWriter.h"

// SAMCPU inputImage outputImage sizex sizey pixelRef0 pixelRef1 pixelRef2 pixelRef3 nbthreads
// ./SAMCPU ~/OTB/trunk/OTB-Data/LargeInput/QUICKBIRD/TOULOUSE/000000128955_01_P001_MUL/02APR01105228-M1BS-000000128955_01_P001.TIF samcpu.tif 5000 5000 230 347 314 388 8

int main(int argc, char *argv[])
{
  if (argc != 10)
    {
    std::cerr << "Wrong Parameters " << std::endl;
    std::cerr << "Usage: " << argv[0];
    std::cerr <<
    " inputImage outputImage sizex sizey pixelRef0 pixelRef1 pixelRef2 pixelRef3 nbthreads"
              << std::endl;
    return EXIT_FAILURE;
    }

  const unsigned int Dimension = 2;
  typedef float                                  PixelType;
  typedef otb::VectorImage<PixelType, Dimension> InputImageType;
  typedef otb::Image<PixelType, Dimension>      OutputImageType;

  typedef otb::ImageFileReader<InputImageType>  ReaderType;
  typedef otb::ImageFileWriter<OutputImageType> WriterType;

  typedef otb::SpectralAngleDistanceImageFilter<InputImageType,
                                                OutputImageType> SAFilterType;

  
  unsigned int extractSizeX = atoi(argv[3]);
  unsigned int extractSizeY = atoi(argv[4]);
  unsigned int nbthreads = atoi(argv[9]);


  typedef otb::MultiChannelExtractROI<PixelType, PixelType> ExtractROIFilterType;


  ReaderType::Pointer reader = ReaderType::New();
  reader->SetFileName(argv[1]);

  ExtractROIFilterType::Pointer roiFilter = ExtractROIFilterType::New();

  roiFilter->SetStartX(0);
  roiFilter->SetStartY(0);
  roiFilter->SetSizeX(extractSizeX);
  roiFilter->SetSizeY(extractSizeY);

  roiFilter->SetInput( reader->GetOutput() );

  SAFilterType::Pointer saFilter = SAFilterType::New();

  InputImageType::PixelType pixelRef;
  pixelRef.SetSize(4);
  pixelRef[0] = atoi(argv[5]);
  pixelRef[1] = atoi(argv[6]);
  pixelRef[2] = atoi(argv[7]);
  pixelRef[3] = atoi(argv[8]);

  
  saFilter->SetReferencePixel(pixelRef);


  saFilter->SetInput(roiFilter->GetOutput());


  saFilter->SetNumberOfThreads(nbthreads);

  WriterType::Pointer writer = WriterType::New();
  writer->SetFileName(argv[2]);
  writer->SetInput(saFilter->GetOutput());

  timespec startClock, endClock;
  time_t startTime = time(NULL);
  clock_t startNdvi = clock();
  clock_gettime(CLOCK_REALTIME, &startClock);

  writer->Update();

  clock_gettime(CLOCK_REALTIME, &endClock);
  clock_t endNdvi = clock();
  time_t endTime = time(NULL);

  std::cout << "Time1: " << std::setprecision(15)
            << (endNdvi-startNdvi)/((float) CLOCKS_PER_SEC) << std::endl;
  std::cout << "Time2: " << std::setprecision(15)
            << (endTime-startTime) << std::endl;
  std::cout << "Time3: " << std::setprecision(15)
            << (endClock.tv_sec-startClock.tv_sec) + (endClock.tv_nsec-startClock.tv_nsec)/1000000000. << std::endl;


  
  return EXIT_SUCCESS;
}
