
#include "otbSiftFastImageFilter.h"
#include "otbImage.h"
#include "otbImageFileReader.h"
#include "otbImageFileWriter.h"
#include "itkPointSet.h"
#include "itkVariableLengthVector.h"
#include "itkRGBPixel.h"
#include "itkImageRegionIterator.h"
#include "otbExtractROI.h"
#include "otbStreamingStatisticsImageFilter.h"
#include "otbGPUPointSetToDensityImageFilter.h"
#include "itkScalarToRGBColormapImageFilter.h"
#include "otbScalarToRainbowRGBPixelFunctor.h"
#include "itkShiftScaleImageFilter.h"
#include "itkBinaryFunctorImageFilter.h"
#include "otbHillShadingFunctor.h"

#include <iostream>
#include <fstream>

// ./SIFTDensity ~/OTB/trunk/OTB-Data/LargeInput/QUICKBIRD/TOULOUSE/000000128955_01_P001_PAN/02APR01105228-P1BS-000000128955_01_P001.TIF outputSIFT.png 10 2000 2000

int main(int argc, char * argv[])
{
  if (argc != 6)
    {
    std::cerr << "Usage: " << argv[0];
    std::cerr << " InputImage OutputImage scales sizex sizey" << std::endl;
    return 1;
    }
  const char * infname = argv[1];
  const char * outputImageFilename = argv[2];

  const unsigned int scales = atoi(argv[3]);

  const unsigned int Dimension = 2;

  typedef float                           PixelType;
  typedef otb::Image<PixelType, Dimension> ImageType;
  typedef otb::ImageFileReader<ImageType> ReaderType;

  typedef itk::VariableLengthVector<PixelType>      RealVectorType;
  typedef itk::PointSet<RealVectorType, Dimension> PointSetType;

  typedef otb::SiftFastImageFilter<ImageType, PointSetType>
  ImageToFastSIFTKeyPointSetFilterType;
  ReaderType::Pointer reader = ReaderType::New();
  reader->SetFileName(infname);

  unsigned int extractSizeX = atoi(argv[4]);
  unsigned int extractSizeY = atoi(argv[5]);
  unsigned int originX = 2000;
  unsigned int originY = 2800;

  typedef otb::ExtractROI<PixelType, PixelType> ExtractROIFilterType;


  ExtractROIFilterType::Pointer roiFilter = ExtractROIFilterType::New();

  roiFilter->SetStartX(originX);
  roiFilter->SetStartY(originY);
  roiFilter->SetSizeX(extractSizeX);
  roiFilter->SetSizeY(extractSizeY);

  roiFilter->SetInput( reader->GetOutput() );

  ImageToFastSIFTKeyPointSetFilterType::Pointer filter =
    ImageToFastSIFTKeyPointSetFilterType::New();

  filter->SetInput(roiFilter->GetOutput());
  filter->SetScalesNumber(scales);
  filter->Update();

  std::cout << filter->GetOutput()->GetNumberOfPoints() << std::endl;
  std::cout << filter->GetOutput()->GetPoints()->GetElement(0) << std::endl;

  typedef otb::GPUPointSetToDensityImageFilter<PointSetType, ImageType> PSDensityFilterType;
  PSDensityFilterType::Pointer density = PSDensityFilterType::New();
  density->SetInput(filter->GetOutput());
  density->SetRadius(25);
  ImageType::SizeType size;
  size[0] = extractSizeX;
  size[1] = extractSizeY;
  density->SetSize(size);
  ImageType::PointType origin;
  origin[0] = originX;
  origin[1] = originY;
  density->SetOrigin(origin);

  density->Update();

  typedef otb::StreamingStatisticsImageFilter<ImageType> StatFilterType;
  StatFilterType::Pointer stat = StatFilterType::New();
  stat->SetInput(density->GetOutput());
  stat->Update();
  double min = stat->GetMinimum();
  double max = stat->GetMaximum();

  typedef unsigned char UCharPixelType;
  typedef itk::RGBPixel<UCharPixelType> RGBPixelType;
  typedef otb::Image<RGBPixelType, 2> RGBImageType;
  typedef itk::ScalarToRGBColormapImageFilter<ImageType, RGBImageType> ColorMapFilterType;
  ColorMapFilterType::Pointer colormapper = ColorMapFilterType::New();
  typedef otb::Functor::ScalarToRainbowRGBPixelFunctor<PixelType, RGBPixelType> ColorMapFunctorType;
  ColorMapFunctorType::Pointer colormap = ColorMapFunctorType::New();
  colormapper->SetColormap(colormap);
  colormap->SetMinimumInputValue(min);
  colormap->SetMaximumInputValue(max);
  colormapper->UseInputImageExtremaForScalingOff();
  colormapper->SetInput(density->GetOutput());

  StatFilterType::Pointer stat2 = StatFilterType::New();
  stat2->SetInput(roiFilter->GetOutput());
  stat2->Update();
  double minImage = stat2->GetMinimum();
  double maxImage = stat2->GetMaximum();
  std::cout << "Min, max: " << minImage << ", " << maxImage << std::endl;

  typedef itk::ShiftScaleImageFilter<ImageType, ImageType> ShiftScaleFilterType;
  ShiftScaleFilterType::Pointer rescale = ShiftScaleFilterType::New();
  rescale->SetShift(-minImage+0.7*0.8*(maxImage-minImage));//increase the dynamic, and end up between 0.5 and 1.0
  rescale->SetScale(1/(2*0.8*(maxImage-minImage)));
  rescale->SetInput(roiFilter->GetOutput());

  typedef itk::BinaryFunctorImageFilter<RGBImageType, ImageType, RGBImageType,
                                        otb::Functor::
                                        HillShadeModulationFunctor<RGBPixelType,
                                                                   PixelType,
                                                                   RGBPixelType> >
  MultiplyFilterType;

  MultiplyFilterType::Pointer multiply = MultiplyFilterType::New();
  multiply->SetInput1(colormapper->GetOutput());
  multiply->SetInput2(rescale->GetOutput());


  typedef otb::ImageFileWriter<RGBImageType> WriterType;
  WriterType::Pointer writer = WriterType::New();
  writer->SetFileName(outputImageFilename);
  writer->SetInput(multiply->GetOutput());
  writer->Update();

//  typedef otb::ImageFileWriter<ImageType> WriterType;
//  WriterType::Pointer writer = WriterType::New();
//  writer->SetFileName(outputImageFilename);
//  writer->SetInput(rescale->GetOutput());
//  writer->Update();
  return EXIT_SUCCESS;
}
