/*
 * otbGPUNDVIFilter.h
 *
 *  Created on: Apr 26, 2010
 *      Author: christop
 */

#ifndef __otbGPUNDVIFilter_h
#define __otbGPUNDVIFilter_h

#include "itkUnaryFunctorImageFilter.h"


namespace otb
{
namespace Function
{
template <class TInputPixel, class TOutputPixel>
class Dummy
{
public:
  Dummy(){}
  virtual ~Dummy(){}
  bool operator !=(const Dummy&) const
  {
    return false;
  }
  bool operator ==(const Dummy& other) const
  {
    return !(*this != other);
  }

  inline TOutputPixel operator ()(const TInputPixel& A) const
  {
    TOutputPixel B;
    return static_cast<TOutputPixel>(B);
  }
};
}


template<class TInputImage, class TOutputImage>
class ITK_EXPORT GPUNDVIFilter: public itk::UnaryFunctorImageFilter<TInputImage, TOutputImage, Function::Dummy<
    typename TInputImage::PixelType, typename TOutputImage::PixelType> >
{
public:
  /** Standard class typedefs. */
  typedef GPUNDVIFilter Self;
  typedef itk::UnaryFunctorImageFilter<TInputImage, TOutputImage,Function::Dummy<
  typename TInputImage::PixelType, typename TOutputImage::PixelType> > Superclass;
  typedef itk::SmartPointer<Self> Pointer;
  typedef itk::SmartPointer<const Self> ConstPointer;

  /** Method for creation through the object factory. */
  itkNewMacro(Self);

  /** Run-time type information (and related methods). */
  itkTypeMacro(GPUNDVIFilter, UnaryFunctorImageFilter);

  typedef TInputImage  InputImageType;
  typedef TOutputImage OutputImageType;

  typedef itk::ImageRegionConstIterator<InputImageType> InputImageConstIterator;
  typedef itk::ImageRegionIterator<InputImageType> InputImageIterator;

  typedef itk::ImageRegionConstIterator<OutputImageType> OutputImageConstIterator;
  typedef itk::ImageRegionIterator<OutputImageType> OutputImageIterator;
  typedef typename  Superclass::OutputImageRegionType   OutputImageRegionType;

  typedef typename OutputImageType::RegionType RegionType;

  /** Set/Get the red channel index. Value must be in [1...[ */
  itkSetMacro(RedIndex, unsigned int)
  itkGetMacro(RedIndex, unsigned int)

  /** Set/Get the nir channel index. Value must be in [1...[ */
  itkSetMacro(NIRIndex, unsigned int)
  itkGetMacro(NIRIndex, unsigned int)

protected:
  /// Constructor
  GPUNDVIFilter() :
    m_RedIndex(3), m_NIRIndex(4)
  {
    m_BlkSize[0] = 8;
    m_BlkSize[1] = 16;
    this->SetNumberOfThreads(1);
  }

  /// Destructor
  virtual ~GPUNDVIFilter(){}

  /**
   * Main computation method.
   */
  void ThreadedGenerateData(const OutputImageRegionType& outputRegionForThread,
                            int threadId );


  virtual RegionType PadBlockRegion(RegionType region);

  virtual void DoProcessing();

private:
  GPUNDVIFilter(const Self &); //purposely not implemented
  void operator =(const Self&); //purposely not implemented

  /** Red channel index */
  unsigned int m_RedIndex;
  /** NIR channel index */
  unsigned int m_NIRIndex;

  int m_BlkSize[2];
  typename OutputImageType::Pointer m_OutputIntermediatePtr;
  typename InputImageType::Pointer m_InputIntermediatePtr;
  RegionType m_ExtendedRegion;
};
} // end namespace otb

#ifndef OTB_MANUAL_INSTANTIATION
#include "otbGPUNDVIFilter.txx"
#endif

#endif
