/*
 * otbGPUGPUPointSetToDensityImageFilter.h
 *
 *  Created on: 09-Mar-2010
 *      Author: christop
 */

#ifndef __otbGPUPointSetToDensityImageFilter_h
#define __otbGPUPointSetToDensityImageFilter_h

#include "otbPointSetToDensityImageFilter.h"

namespace otb
{

/** \class GPUPointSetToDensityImageFilter
 *  \brief Draw the density of a point set on an image
 */

template <class TInputPointSet , class TOutputImage>
class ITK_EXPORT GPUPointSetToDensityImageFilter
: public PointSetToDensityImageFilter<TInputPointSet, TOutputImage >
{
public:
  /** Standard class typedefs. */
  typedef GPUPointSetToDensityImageFilter Self;
  typedef PointSetToDensityImageFilter<TInputPointSet, TOutputImage> Superclass;
  typedef itk::SmartPointer<Self> Pointer;
  typedef itk::SmartPointer<const Self> ConstPointer;

  /** Method for creation through the object factory. */
  itkNewMacro(Self);

  /** Run-time type information (and related methods). */
  itkTypeMacro(PointSetToDensityImageFilter, PointSetToDensityImageFilter);

  typedef TOutputImage ImageType;
  typedef TInputPointSet                          PointSetType;

  typedef typename ImageType::RegionType RegionType;
  typedef typename Superclass::PointSetDensityFunctionType   PointSetDensityFunctionType;
  typedef typename Superclass::PointSetDensityFunctionPointerType   PointSetDensityFunctionPointerType;
  typedef typename Superclass::InputType InputType;
  typedef typename Superclass::IndexType IndexType;

  typedef itk::ImageRegionConstIterator<ImageType> ImageConstIterator;
  typedef itk::ImageRegionIterator<ImageType> ImageIterator;

  typedef typename  Superclass::OutputImageRegionType   OutputImageRegionType;

protected:
  GPUPointSetToDensityImageFilter()
  {
    m_BlkSize[0]=8*4;
    m_BlkSize[1]=16;
    this->SetNumberOfThreads(1);
  }

  /// Destructor
  virtual ~GPUPointSetToDensityImageFilter(){}


  /**
   * Main computation method.
   */
  void ThreadedGenerateData(const OutputImageRegionType& outputRegionForThread,
                            int threadId );


  virtual RegionType PadBlockRegion(RegionType region);

// CPU version
//  virtual void DoProcessing()
//  {
//    PointSetDensityFunctionPointerType densityComputeFunction = PointSetDensityFunctionType::New();
//    densityComputeFunction->SetPointSet(this->GetInput());
//    densityComputeFunction->SetRadius(this->GetRadius());
//
//    /** Point*/
//    InputType pCenter;
//    IndexType index;
//    ImageIterator itInterm(m_OutputIntermediatePtr, m_ExtendedRegion);
//    itInterm.GoToBegin();
//
//    while (!itInterm.IsAtEnd())
//    {
//      index = itInterm.GetIndex();
//      m_OutputIntermediatePtr->TransformIndexToPhysicalPoint(index, pCenter);
//
//      itInterm.Set(densityComputeFunction->Evaluate(pCenter));
//      ++itInterm;
//    }
//  }

  virtual void DoProcessing();

private:
  GPUPointSetToDensityImageFilter(const Self &); //purposely not implemented
  void operator =(const Self&); //purposely not implemented

  int m_BlkSize[2];
  typename ImageType::Pointer m_OutputIntermediatePtr;
  RegionType m_ExtendedRegion;
};
}
#ifndef OTB_MANUAL_INSTANTIATION
#include "otbGPUPointSetToDensityImageFilter.txx"
#endif

#endif
