/*
 * otbGPUGPUPointSetToDensityImageFilter.txx
 *
 *  Created on: 10-Mar-2010
 *      Author: christop
 */
#ifndef __otbGPUPointSetToDensityImageFilter_txx
#define __otbGPUPointSetToDensityImageFilter_txx

#include "otbGPUPointSetToDensityImageFilter.h"

extern "C" void pointDensityProcessing(float* pix, float* pt, int numPoint, int originX, int originY, float spacingX, float spacingY, int imageWidth, int imageHeight, int radius);

namespace otb
{

/*-------------------------------------------------------
 * ThreadedGenerateData
 --------------------------------------------------------*/
template <class TInputPointSet, class TOutputImage>
void
GPUPointSetToDensityImageFilter<TInputPointSet, TOutputImage>
::ThreadedGenerateData(
    const   OutputImageRegionType&     outputRegionForThread,
    int   threadId)
{
  typename ImageType::Pointer outputPtr = dynamic_cast<ImageType *> (this->itk::ProcessObject::GetOutput(0));

//  std::cout << outputRegionForThread << std::endl;
//  std::cout << outputPtr->GetOrigin() << std::endl;

  bool padding = false;
  m_ExtendedRegion = PadBlockRegion(outputRegionForThread);
  if (m_ExtendedRegion != this->GetOutput()->GetRequestedRegion())
  {
    padding = true;
  }

  if (padding)
  {
    m_OutputIntermediatePtr = ImageType::New();
    m_OutputIntermediatePtr->CopyInformation(outputPtr);
    m_OutputIntermediatePtr->SetBufferedRegion(m_ExtendedRegion);
    m_OutputIntermediatePtr->Allocate();
  }
  else
  {
    outputPtr->SetBufferedRegion(outputRegionForThread);
    outputPtr->Allocate();
    m_OutputIntermediatePtr = outputPtr;
  }

  //Superclass::GenerateData();
  //Do processing here
  this->DoProcessing();

  //handle the output

  if (padding)
  {
    outputPtr->SetBufferedRegion(outputRegionForThread);
    outputPtr->Allocate();
    ImageConstIterator it = ImageConstIterator(m_OutputIntermediatePtr, outputRegionForThread);
    ImageIterator itOut = ImageIterator(outputPtr, outputRegionForThread);
    for (it.GoToBegin(), itOut.GoToBegin(); !it.IsAtEnd(); ++it, ++itOut)
    {
      itOut.Set(it.Get());
    }

  }
  else
  {
    outputPtr = m_OutputIntermediatePtr;
  }

}

template<class TInputPointSet, class TOutputImage>
typename GPUPointSetToDensityImageFilter<TInputPointSet, TOutputImage>::RegionType
GPUPointSetToDensityImageFilter<TInputPointSet, TOutputImage>
::PadBlockRegion(RegionType region)
{
  typename RegionType::SizeType size = region.GetSize();
  std::cout << "Size before padding: " << size << std::endl;
  if ((size[0] % m_BlkSize[0]) != 0)
    size[0] = size[0] + m_BlkSize[0] - (size[0] % m_BlkSize[0]);
  if ((size[1] % m_BlkSize[1]) != 0)
    size[1] = size[1] + m_BlkSize[1] - (size[1] % m_BlkSize[1]);
  std::cout << "Size after padding: " << size << std::endl;
  region.SetSize(size);
  return region;
}

// CPU version
//  virtual void DoProcessing()
//  {
//    PointSetDensityFunctionPointerType densityComputeFunction = PointSetDensityFunctionType::New();
//    densityComputeFunction->SetPointSet(this->GetInput());
//    densityComputeFunction->SetRadius(this->GetRadius());
//
//    /** Point*/
//    InputType pCenter;
//    IndexType index;
//    ImageIterator itInterm(m_OutputIntermediatePtr, m_ExtendedRegion);
//    itInterm.GoToBegin();
//
//    while (!itInterm.IsAtEnd())
//    {
//      index = itInterm.GetIndex();
//      m_OutputIntermediatePtr->TransformIndexToPhysicalPoint(index, pCenter);
//
//      itInterm.Set(densityComputeFunction->Evaluate(pCenter));
//      ++itInterm;
//    }
//  }

template<class TInputPointSet, class TOutputImage>
void GPUPointSetToDensityImageFilter<TInputPointSet, TOutputImage>
::DoProcessing()
{
  typename ImageType::Pointer outputPtr = dynamic_cast<ImageType *> (this->itk::ProcessObject::GetOutput(0));
  //Translate to simple CPU structure
  float * pix = m_OutputIntermediatePtr->GetBufferPointer();
  int originX = m_OutputIntermediatePtr->GetBufferedRegion().GetIndex()[0]
               + outputPtr->GetOrigin()[0];
  int originY = m_OutputIntermediatePtr->GetBufferedRegion().GetIndex()[1]
               + outputPtr->GetOrigin()[1];
  float spacingX = m_OutputIntermediatePtr->GetSpacing()[0];
  float spacingY = m_OutputIntermediatePtr->GetSpacing()[1];
  int imageWidth = m_OutputIntermediatePtr->GetBufferedRegion().GetSize()[0];
  int imageHeight = m_OutputIntermediatePtr->GetBufferedRegion().GetSize()[1];
  int radius = this->GetRadius();
  std::cout << "Radius: " << radius << std::endl;
  //    TransformIndexToPhysicalPoint
  int numPoint = this->GetInput()->GetNumberOfPoints();//FIXME check int vs long

  float * pt = new float[2 * numPoint];

  typedef typename PointSetType::PointsContainer::ConstIterator iteratorType;
  iteratorType it = this->GetInput()->GetPoints()->Begin();
  int i = 0;
  while (it != this->GetInput()->GetPoints()->End())
  {
    pt[2 * i] = it.Value()[0];
    pt[2 * i + 1] = it.Value()[1];
    ++it;
    ++i;
  }

  std::cout << "Few point: " << pt[0]<<", " << pt[1] << " " << pt[2]<<", " << pt[3] << std::endl; 

  //Call GPU translation method
  std::cout << "Calling GPU translation method" << std::endl;
  pointDensityProcessing(pix, pt, numPoint, originX, originY, spacingX, spacingY, imageWidth, imageHeight, radius);

  delete[] pt;
}

}

#endif
