/*
 * otbGPUSAMFilter.h
 *
 *  Created on: Apr 26, 2010
 *      Author: christop
 */

#ifndef __otbGPUSAMFilter_h
#define __otbGPUSAMFilter_h

#include "otbSpectralAngleDistanceImageFilter.h"


namespace otb
{



template<class TInputImage, class TOutputImage>
class ITK_EXPORT GPUSAMFilter: public SpectralAngleDistanceImageFilter<TInputImage, TOutputImage>
{
public:
  /** Standard class typedefs. */
  typedef GPUSAMFilter Self;
  typedef SpectralAngleDistanceImageFilter<TInputImage, TOutputImage> Superclass;
  typedef itk::SmartPointer<Self> Pointer;
  typedef itk::SmartPointer<const Self> ConstPointer;

  /** Method for creation through the object factory. */
  itkNewMacro(Self);

  /** Run-time type information (and related methods). */
  itkTypeMacro(GPUSAMFilter, SpectralAngleDistanceImageFilter);

  typedef TInputImage  InputImageType;
  typedef TOutputImage OutputImageType;

  typedef itk::ImageRegionConstIterator<InputImageType> InputImageConstIterator;
  typedef itk::ImageRegionIterator<InputImageType> InputImageIterator;

  typedef itk::ImageRegionConstIterator<OutputImageType> OutputImageConstIterator;
  typedef itk::ImageRegionIterator<OutputImageType> OutputImageIterator;
  typedef typename  Superclass::OutputImageRegionType   OutputImageRegionType;

  typedef typename OutputImageType::RegionType RegionType;


protected:
  /// Constructor
  GPUSAMFilter()
  {
    m_BlkSize[0] = 8;
    m_BlkSize[1] = 16;
    this->SetNumberOfThreads(1);
  }

  /// Destructor
  virtual ~GPUSAMFilter(){}

  /**
   * Main computation method.
   */
  void ThreadedGenerateData(const OutputImageRegionType& outputRegionForThread,
                            int threadId );


  virtual RegionType PadBlockRegion(RegionType region);

  virtual void DoProcessing();

private:
  GPUSAMFilter(const Self &); //purposely not implemented
  void operator =(const Self&); //purposely not implemented

  int m_BlkSize[2];
  typename OutputImageType::Pointer m_OutputIntermediatePtr;
  typename InputImageType::Pointer m_InputIntermediatePtr;
  RegionType m_ExtendedRegion;
};
} // end namespace otb

#ifndef OTB_MANUAL_INSTANTIATION
#include "otbGPUSAMFilter.txx"
#endif

#endif
