/*
 * otbOCLPointSetToDensityImageFilter.h
 *
 *  Created on: 14-Apr-2010
 *      Author: christop
 */

#ifndef __otbOCLPointSetToDensityImageFilter_h
#define __otbOCLPointSetToDensityImageFilter_h

#include "otbPointSetToDensityImageFilter.h"

#include <CL/cl.h>

namespace otb
{

/** \class OCLPointSetToDensityImageFilter
 *  \brief Draw the density of a point set on an image
 */

template <class TInputPointSet , class TOutputImage>
class ITK_EXPORT OCLPointSetToDensityImageFilter
: public PointSetToDensityImageFilter<TInputPointSet, TOutputImage >
{
public:
  /** Standard class typedefs. */
  typedef OCLPointSetToDensityImageFilter Self;
  typedef PointSetToDensityImageFilter<TInputPointSet, TOutputImage> Superclass;
  typedef itk::SmartPointer<Self> Pointer;
  typedef itk::SmartPointer<const Self> ConstPointer;

  /** Method for creation through the object factory. */
  itkNewMacro(Self);

  /** Run-time type information (and related methods). */
  itkTypeMacro(PointSetToDensityImageFilter, PointSetToDensityImageFilter);

  typedef TOutputImage ImageType;
  typedef TInputPointSet                          PointSetType;

  typedef typename ImageType::RegionType RegionType;
  typedef typename Superclass::PointSetDensityFunctionType   PointSetDensityFunctionType;
  typedef typename Superclass::PointSetDensityFunctionPointerType   PointSetDensityFunctionPointerType;
  typedef typename Superclass::InputType InputType;
  typedef typename Superclass::IndexType IndexType;

  typedef itk::ImageRegionConstIterator<ImageType> ImageConstIterator;
  typedef itk::ImageRegionIterator<ImageType> ImageIterator;

  typedef typename  Superclass::OutputImageRegionType   OutputImageRegionType;

protected:
  OCLPointSetToDensityImageFilter()
  {
    m_BlkSize[0]=8*4;
    m_BlkSize[1]=16;
    this->SetNumberOfThreads(1);
  }

  void BeforeThreadedGenerateData();
  void AfterThreadedGenerateData();

  /**
   * Main computation method.
   */
  void ThreadedGenerateData(const OutputImageRegionType& outputRegionForThread,
                            int threadId );


  virtual RegionType PadBlockRegion(RegionType region);


  virtual void DoProcessing();
  virtual void LaunchKernel(float* pix, float* pt, int numPoint, int originX, int originY, float spacingX, float spacingY, int imageWidth, int imageHeight, int radius);

private:
  int m_BlkSize[2];
  typename ImageType::Pointer m_OutputIntermediatePtr;
  RegionType m_ExtendedRegion;

  cl_context GPUContext;
  cl_command_queue GPUCommandQueue;
  cl_program pointSetProgram;
  cl_kernel pointDensityKernel;
  cl_kernel zeroImageKernel;

  itk::SimpleFastMutexLock m_Mutex;


};
}
#ifndef OTB_MANUAL_INSTANTIATION
#include "otbOCLPointSetToDensityImageFilter.txx"
#endif

#endif
