# Generated by OTB cmake files, do not edit
#
# Copyright (C) 2005-2024 Centre National d'Etudes Spatiales (CNES)
#
# This file is part of Orfeo Toolbox
#
#     https://www.orfeo-toolbox.org/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#-----------------------------------------------------------------------------
#
# CoreConfig.cmake - OTB CMake configuration file for external projects.
# This file is read by cmake when the "find_package(OTB COMPONENTS Core)" is used
# To correctly configure this file you need the following variables:
# - otb-group
# - GROUP_DEPS
# - __ENABLED_MODULES
# - OTB_VERSION_MAJOR
# - OTB_VERSION_MINOR

# do not read file twice
if (DEFINED Core_FOUND)
  return()
endif()

set(GROUP_DEPENDENCIES "")

# until all the process of this file is successfull, group is considerate as
# unfound
set(Core_FOUND 0)

set(OTB_Core_MODULES_ENABLED "OTBAppCore;OTBColorMap;OTBCommon;OTBComplexImage;OTBConversion;OTBConvolution;OTBDEM;OTBDensity;OTBDescriptors;OTBEdge;OTBFunctor;OTBImageBase;OTBImageList;OTBImageManipulation;OTBIndices;OTBInterpolation;OTBLabelMap;OTBMetadata;OTBMoments;OTBMosaic;OTBObjectList;OTBOpticalCalibration;OTBPanSharpening;OTBPath;OTBPointSet;OTBProjection;OTBSmoothing;OTBStatistics;OTBStreaming;OTBTransform;OTBVectorDataBase;OTBVectorDataManipulation;OTBTemporalGapFilling;S1TilingSupportApplications;SertitObject;otbGRM;OTB6S;OTBBoost;OTBCurl;OTBDate;OTBGDAL;OTBGSL;OTBITK;OTBLibSVM;OTBMuParser;OTBMuParserX;OTBOpenCV;OTBShark;OTBSiftFast;OTBTinyXML;OTBBoostAdapters;OTBCurlAdapters;OTBGdalAdapters;OTBFuzzy;OTBMajorityVoting;OTBCarto;OTBExtendedFilename;OTBIOGDAL;OTBIOXML;OTBImageIO;OTBTestKernel;OTBVectorDataIO;OTBApplicationEngine;OTBCommandLine;OTBQGIS;OTBSWIGWrapper")

foreach(__group IN LISTS GROUP_DEPENDENCIES)
  message(STATUS "[CoreConfig] Try to find needed ${__group} dependency")
  # When using find_package, cmake will look for directories using the name of
  # the package provided (the first arg).
  # It will look in the following directories https://cmake.org/cmake/help/v3.29/command/find_package.html#config-mode-search-procedure
  # Package Name is here an OTB modules where cmake files are installed
  # in the same tree as OTB files, not a dedicated directory.
  # Thus cmake will look for a folder with component name which does not exists.
  # The PATH_SUFFIXES option help to find it

  # Force the REQUIRED there as we are trying to find a dependency
  find_package(${__group} CONFIG REQUIRED PATH_SUFFIXES "lib/cmake/OTB-10.0")
  #list(APPEND OTB_Core_MODULES_ENABLED "${OTB_${__group}_MODULES_ENABLED}")
endforeach()

# if we are here in the process as all dependency has been found, otherwise
# the find_package emit a FATAL_ERROR
set(Core_FOUND 1)

get_filename_component(_GROUP_CMAKEDIR "${CMAKE_CURRENT_LIST_FILE}" PATH)
# remove last OTB-<MAJOR>-<MINOR>
get_filename_component(TMP_DIR_VAR "${_GROUP_CMAKEDIR}" DIRECTORY)
# remove last cmake
get_filename_component(TMP_DIR_VAR "${TMP_DIR_VAR}" DIRECTORY)
# remove last lib, store this in specific var which is also referenced in
# the specific file in cmake/Module/<module-name>.cmake
get_filename_component(GROUP_Core_LOCATION "${TMP_DIR_VAR}" DIRECTORY)

# enrich the OTB_MODULES_DIRS with the directory of this specific module
# in case it is separated. This will later help to find the localisation
# of cmake file relative to modules of this Group
# In case module is in the same package as OTB, the duplicate will be remove
list(APPEND OTB_MODULES_DIRS "${_GROUP_CMAKEDIR}/Modules")
list(REMOVE_DUPLICATES OTB_MODULES_DIRS)

if (NOT EXISTS "${_GROUP_CMAKEDIR}/CoreTargets.cmake")
  set(Core_FOUND 0)
  # inform but do not use FATAL_ERROR as the component can be optionnal
  message(WARNING "[CoreConfig] Can not find required CoreTarget file in ${_GROUP_CMAKEDIR}")
else()
  message(STATUS "[CoreConfig] Reading CoreTarget file in ${_GROUP_CMAKEDIR}")
  include(${_GROUP_CMAKEDIR}/CoreTargets.cmake)
endif()

# set an all capitals FOUND var to stick to standart
string(TOUPPER "Core" UPPER_GROUP_NAME)
set(${UPPER_GROUP_NAME}_FOUND ${Core_FOUND})

unset(GROUP_DEPENDENCIES)
unset(_GROUP_CMAKEDIR)
