#!/bin/sh
#
# Copyright (C) 2005-2024 Centre National d'Etudes Spatiales (CNES)
#
# This file is part of Orfeo Toolbox
#
#     https://www.orfeo-toolbox.org/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# avoid magic number. Version filled by cmake
OTB_SHORT_VERSION=9.1

echo "***** First time launching OTB after installation, doing some post installation steps before use *****"
# Apply necessary patches for a modular install because cmake generates these file at configure time, not at packaging time
CMAKE_DIRS="$OTB_INSTALL_DIR/lib/cmake"
sed -i "s/FATAL_ERROR/WARNING/g" "$CMAKE_DIRS/OTB-$OTB_SHORT_VERSION/OTBTargets.cmake"
sed -i "s/FATAL_ERROR/WARNING/g" "$CMAKE_DIRS/OTB-$OTB_SHORT_VERSION/OTBModuleAPI.cmake"
sed -i "s/\/builds\/otb\/xdk/\${OTB_INSTALL_PREFIX}/g" "$CMAKE_DIRS"/OTB-"$OTB_SHORT_VERSION"/*.cmake
sed -i "s/\/builds\/otb\/xdk/\${OTB_INSTALL_PREFIX}/g" "$CMAKE_DIRS"/OTB-"$OTB_SHORT_VERSION"/Modules/*.cmake
sed -i "s/\/builds\/otb\/xdk/\${OTB_INSTALL_PREFIX}/g" "$CMAKE_DIRS"/ITK-4.13/*.cmake
sed -i "s/\/builds\/otb\/xdk/\${OTB_INSTALL_PREFIX}/g" "$CMAKE_DIRS"/ITK-4.13/Modules/*.cmake
sed -i "s/\/builds\/otb\/xdk/\$OTB_INSTALL_DIR/g" "$OTB_INSTALL_DIR"/bin/gdal-config
sed -i "s/\/builds\/otb\/xdk/\$OTB_INSTALL_DIR/g" "$OTB_INSTALL_DIR"/bin/curl-config
sh "$OTB_INSTALL_DIR"/tools/sanitize_rpath.sh

# Check python version, if python 3.10 (ubuntu 22 and debian 12) download and extract the gdal bindings for python 3.10
complete_pyversion=$(python3 -V | cut -f2 -d' ')
pyversion="$(python3 -V 2>&1 | sed 's/.* \([0-9]\).\([0-9]*\).*/\1\2/')"
short_pyversion="$(python3 -V 2>&1 | sed 's/.* \([0-9]\).\([0-9]*\).*/\1.\2/')"
if [ $pyversion -ge 310 ]; then
    echo "*** Python $complete_pyversion detected, downloading gdal bindings compiled for python $short_pyversion ***"
    curl "https://www.orfeo-toolbox.org/packages/archives/OTB/OTB-$OTB_SHORT_VERSION-GDAL-bindings-py$pyversion.tar.gz" -o "$OTB_INSTALL_DIR"/tools/py$pyversion.tar.gz
    tar -xf "$OTB_INSTALL_DIR"/tools/py$pyversion.tar.gz -C "$OTB_INSTALL_DIR"/lib/python3/dist-packages/osgeo/
    rm "$OTB_INSTALL_DIR"/tools/py$pyversion.tar.gz
    echo "*** GDAL bindings for python $short_pyversion successfully installed ***"
fi
echo "OK" > "$OTB_INSTALL_DIR"/tools/install_done.txt
